//GEMINI-pro DATASET v1.0 Category: Networking ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080

int main()
{
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1)
    {
        perror("socket");
        exit(1);
    }

    // Bind the socket to an address
    struct sockaddr_in addr;
    addr.sin_family = AF_INET;
    addr.sin_port = htons(PORT);
    addr.sin_addr.s_addr = htonl(INADDR_ANY);
    if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) == -1)
    {
        perror("bind");
        exit(1);
    }

    // Listen for connections
    if (listen(sock, 5) == -1)
    {
        perror("listen");
        exit(1);
    }

    // Accept a connection
    struct sockaddr_in client_addr;
    socklen_t client_addr_len = sizeof(client_addr);
    int client_sock = accept(sock, (struct sockaddr *)&client_addr, &client_addr_len);
    if (client_sock == -1)
    {
        perror("accept");
        exit(1);
    }

    // Receive data from the client
    char buffer[1024];
    int bytes_received = recv(client_sock, buffer, sizeof(buffer), 0);
    if (bytes_received == -1)
    {
        perror("recv");
        exit(1);
    }

    // Print the data received from the client
    printf("Received: %s\n", buffer);

    // Send data to the client
    char *message = "Hello from the server!";
    int bytes_sent = send(client_sock, message, strlen(message), 0);
    if (bytes_sent == -1)
    {
        perror("send");
        exit(1);
    }

    // Close the client socket
    close(client_sock);

    // Close the server socket
    close(sock);

    return 0;
}