//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define GREEN_DURATION 15
#define YELLOW_DURATION 3
#define RED_DURATION 30
#define TOTAL_DURATION (GREEN_DURATION + YELLOW_DURATION + RED_DURATION)

typedef enum {
    GREEN,
    YELLOW,
    RED
} TrafficLightState;

void print_traffic_light(TrafficLightState state) {
    switch (state) {
        case GREEN:
            printf("Green light\n");
            break;
        case YELLOW:
            printf("Yellow light\n");
            break;
        case RED:
            printf("Red light\n");
            break;
    }
}

int main() {
    srand(time(NULL));
    TrafficLightState state = GREEN;
    int elapsed_time = 0;

    while (elapsed_time < TOTAL_DURATION) {
        elapsed_time++;
        printf("Elapsed time: %d seconds\n", elapsed_time);
        print_traffic_light(state);

        if (state == GREEN) {
            if (elapsed_time >= GREEN_DURATION) {
                state = YELLOW;
            }
        } else if (state == YELLOW) {
            if (elapsed_time >= YELLOW_DURATION) {
                state = RED;
            }
        } else if (state == RED) {
            if (elapsed_time >= RED_DURATION) {
                state = GREEN;
            }
        }

        if (state == GREEN) {
            printf("Pedestrians crossing\n");
        } else {
            printf("No pedestrians crossing\n");
        }

        if (state == RED) {
            printf("Cars waiting\n");
        } else {
            printf("Cars passing\n");
        }

        sleep(1);
    }

    return 0;
}