//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOSTS 5
#define MAX_THINGS 10

typedef struct Ghost {
    char name[20];
    int room;
    int appeased;
} Ghost;

typedef struct Thing {
    char name[20];
    int location;
    int activated;
} Thing;

Ghost ghosts[MAX_GHOSTS];
Thing things[MAX_THINGS];

void initializeGhosts() {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        ghosts[i].name[0] = '\0';
        ghosts[i].room = -1;
        ghosts[i]. appeased = 0;
    }
}

void initializeThings() {
    for (int i = 0; i < MAX_THINGS; i++) {
        things[i].name[0] = '\0';
        things[i].location = -1;
        things[i].activated = 0;
    }
}

int main() {
    initializeGhosts();
    initializeThings();

    srand(time(NULL));

    // Create a haunted house
    for (int i = 0; i < MAX_GHOSTS; i++) {
        ghosts[i].name[0] = 'A' + i;
        ghosts[i].room = rand() % 5;
    }

    // Create things
    for (int i = 0; i < MAX_THINGS; i++) {
        things[i].name[0] = 'T' + i;
        things[i].location = rand() % 5;
    }

    // Simulate hauntings
    for (int i = 0; i < MAX_GHOSTS; i++) {
        if (!ghosts[i]. appeased) {
            printf("%s is haunting the %dth room...\n", ghosts[i].name, ghosts[i].room);
        }
    }

    // Simulate things activation
    for (int i = 0; i < MAX_THINGS; i++) {
        if (things[i].activated) {
            printf("%s is activated!\n", things[i].name);
        }
    }

    return 0;
}