//GPT-4o-mini DATASET v1.0 Category: Network Topology Mapper ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_CONNECTIONS 10

struct Node {
    int id;
    char name[20];
    int connections[MAX_CONNECTIONS];
    int conn_count;
};

struct Topology {
    struct Node nodes[MAX_NODES];
    int node_count;
};

// Function to add a node to the topology
void add_node(struct Topology *top, const char *name) {
    if (top->node_count < MAX_NODES) {
        struct Node new_node;
        new_node.id = top->node_count;
        strcpy(new_node.name, name);
        new_node.conn_count = 0;
        top->nodes[top->node_count] = new_node;
        top->node_count++;
    } else {
        printf("Node limit reached!\n");
    }
}

// Function to connect two nodes
void connect_nodes(struct Topology *top, int node_id1, int node_id2) {
    if (node_id1 >= top->node_count || node_id2 >= top->node_count) {
        printf("Invalid node ID(s) provided!\n");
        return;
    }
    if (top->nodes[node_id1].conn_count < MAX_CONNECTIONS && 
        top->nodes[node_id2].conn_count < MAX_CONNECTIONS) {
        top->nodes[node_id1].connections[top->nodes[node_id1].conn_count] = node_id2;
        top->nodes[node_id1].conn_count++;
        top->nodes[node_id2].connections[top->nodes[node_id2].conn_count] = node_id1;
        top->nodes[node_id2].conn_count++;
    } else {
        printf("Connection limit for one of the nodes reached!\n");
    }
}

// Function to print the topology
void print_topology(const struct Topology *top) {
    printf("Network Topology:\n");
    for (int i = 0; i < top->node_count; i++) {
        printf("Node %d: %s\n", top->nodes[i].id, top->nodes[i].name);
        printf("   Connections: ");
        for (int j = 0; j < top->nodes[i].conn_count; j++) {
            printf("%d ", top->nodes[i].connections[j]);
        }
        printf("\n");
    }
}

int main() {
    struct Topology topology;
    topology.node_count = 0;

    add_node(&topology, "Router1");
    add_node(&topology, "Switch1");
    add_node(&topology, "PC1");
    add_node(&topology, "Server1");

    connect_nodes(&topology, 0, 1); // Connect Router1 to Switch1
    connect_nodes(&topology, 1, 2); // Connect Switch1 to PC1
    connect_nodes(&topology, 1, 3); // Connect Switch1 to Server1

    print_topology(&topology);

    return 0;
}