//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCKS 100
#define MAX_NAME_LENGTH 20

typedef struct {
    char name[MAX_NAME_LENGTH];
    double price;
} Stock;

Stock stocks[MAX_STOCKS];
int num_stocks = 0;

void add_stock(char* name, double price) {
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: Cannot add more stocks.\n");
        return;
    }

    strncpy(stocks[num_stocks].name, name, MAX_NAME_LENGTH);
    stocks[num_stocks].price = price;
    num_stocks++;
}

void remove_stock(int index) {
    if (index < 0 || index >= num_stocks) {
        printf("Error: Invalid stock index.\n");
        return;
    }

    num_stocks--;
    for (int i = index; i < num_stocks; i++) {
        strcpy(stocks[i].name, stocks[i+1].name);
        stocks[i].price = stocks[i+1].price;
    }
}

void update_stock_price(int index, double new_price) {
    if (index < 0 || index >= num_stocks) {
        printf("Error: Invalid stock index.\n");
        return;
    }

    stocks[index].price = new_price;
}

void print_stocks() {
    for (int i = 0; i < num_stocks; i++) {
        printf("%s: $%.2f\n", stocks[i].name, stocks[i].price);
    }
}

int main() {
    add_stock("AAPL", 150.00);
    add_stock("GOOG", 1000.00);
    add_stock("MSFT", 200.00);

    print_stocks();

    remove_stock(1);

    print_stocks();

    update_stock_price(0, 175.00);

    print_stocks();

    return 0;
}