//GEMINI-pro DATASET v1.0 Category: Expense Tracker ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Defining the structure of an expense
typedef struct {
    char* name;
    double amount;
    double date;
} Expense;

// Creating an array of expenses
Expense expenses[] = {
    {"Rent", 1000.00, 1650316800},
    {"Groceries", 200.00, 1650380400},
    {"Utilities", 150.00, 1650444800},
    {"Transportation", 500.00, 1650511600},
    {"Entertainment", 100.00, 1650578400},
};

// Function to calculate the total expenses
double totalExpenses() {
    double total = 0.0;
    for (int i = 0; i < sizeof(expenses) / sizeof(expenses[0]); i++) {
        total += expenses[i].amount;
    }
    return total;
}

// Function to calculate the average expenses
double averageExpenses() {
    double total = totalExpenses();
    return total / (sizeof(expenses) / sizeof(expenses[0]));
}

// Function to find the maximum expense
double maxExpense() {
    double max = expenses[0].amount;
    for (int i = 1; i < sizeof(expenses) / sizeof(expenses[0]); i++) {
        if (expenses[i].amount > max) {
            max = expenses[i].amount;
        }
    }
    return max;
}

// Function to find the minimum expense
double minExpense() {
    double min = expenses[0].amount;
    for (int i = 1; i < sizeof(expenses) / sizeof(expenses[0]); i++) {
        if (expenses[i].amount < min) {
            min = expenses[i].amount;
        }
    }
    return min;
}

// Function to print the expenses
void printExpenses() {
    for (int i = 0; i < sizeof(expenses) / sizeof(expenses[0]); i++) {
        printf("%s: $%.2f (%s)\n", expenses[i].name, expenses[i].amount, ctime(&expenses[i].date));
    }
}

// Main function
int main() {
    // Calculating the total expenses
    double total = totalExpenses();

    // Calculating the average expenses
    double average = averageExpenses();

    // Finding the maximum expense
    double max = maxExpense();

    // Finding the minimum expense
    double min = minExpense();

    // Printing the expenses
    printExpenses();

    // Printing the total expenses
    printf("Total expenses: $%.2f\n", total);

    // Printing the average expenses
    printf("Average expenses: $%.2f\n", average);

    // Printing the maximum expense
    printf("Maximum expense: $%.2f\n", max);

    // Printing the minimum expense
    printf("Minimum expense: $%.2f\n", min);

    return 0;
}