//Code Llama-13B DATASET v1.0 Category: Browser Plugin ; Style: irregular
// Browser Plugin Example

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

// Function to check if a string is a valid URL
bool isValidUrl(char* url) {
    // Check if the string is not empty
    if (strlen(url) == 0) {
        return false;
    }

    // Check if the string starts with http:// or https://
    if (strncmp(url, "http://", 7) != 0 && strncmp(url, "https://", 8) != 0) {
        return false;
    }

    // Check if the string has a valid domain name
    if (strchr(url, '.') == NULL) {
        return false;
    }

    // Check if the string has a valid file extension
    char* extension = strchr(url, '.') + 1;
    if (strlen(extension) == 0 || strcmp(extension, "html") != 0) {
        return false;
    }

    return true;
}

// Function to print the URL in a valid format
void printUrl(char* url) {
    // Check if the string is a valid URL
    if (!isValidUrl(url)) {
        printf("Invalid URL: %s\n", url);
        return;
    }

    // Print the URL in a valid format
    char* protocol = "http://";
    char* domain = strchr(url, '.') + 1;
    char* file = strchr(domain, '/') + 1;
    printf("%s%s/%s\n", protocol, domain, file);
}

int main() {
    // Test cases
    char* urls[] = {
        "http://www.example.com/index.html",
        "https://www.example.com/index.html",
        "http://www.example.com/index.html?q=hello",
        "https://www.example.com/index.html?q=hello",
        "http://www.example.com/index.html#anchor",
        "https://www.example.com/index.html#anchor",
        "http://www.example.com/index.html?q=hello#anchor",
        "https://www.example.com/index.html?q=hello#anchor",
        "http://www.example.com/index.html?q=hello#anchor&s=world",
        "https://www.example.com/index.html?q=hello#anchor&s=world",
    };

    int numUrls = sizeof(urls) / sizeof(urls[0]);

    // Iterate over the test cases
    for (int i = 0; i < numUrls; i++) {
        // Print the URL in a valid format
        printUrl(urls[i]);
    }

    return 0;
}