//Falcon-180B DATASET v1.0 Category: Robot movement control ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.1415926535897932384626433832795

// Define the robot's position and orientation
typedef struct {
    double x;
    double y;
    double theta;
} Robot;

// Define the robot's movement functions
void move_forward(Robot *robot, double distance) {
    double delta_x = cos(robot->theta) * distance;
    double delta_y = sin(robot->theta) * distance;
    robot->x += delta_x;
    robot->y += delta_y;
}

void turn_left(Robot *robot, double angle) {
    robot->theta -= angle;
}

void turn_right(Robot *robot, double angle) {
    robot->theta += angle;
}

// Define the main program
int main() {
    // Initialize the robot's position and orientation
    Robot robot = {0.0, 0.0, 0.0};

    // Move the robot forward 10 units
    move_forward(&robot, 10.0);

    // Turn the robot left by 90 degrees
    turn_left(&robot, PI/2);

    // Move the robot forward another 10 units
    move_forward(&robot, 10.0);

    // Turn the robot right by 90 degrees
    turn_right(&robot, PI/2);

    // Move the robot forward a final 10 units
    move_forward(&robot, 10.0);

    // Print the robot's final position and orientation
    printf("Robot's final position: (%.2f, %.2f)\n", robot.x, robot.y);
    printf("Robot's final orientation: %.2f radians\n", robot.theta);

    return 0;
}