//GPT-4o-mini DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define MAX_BAGS 100
#define BAGGAGE_MAX_WEIGHT 30
#define BAGGAGE_TYPE_LEN 20

typedef struct {
    int id;
    char type[BAGGAGE_TYPE_LEN];
    int weight; // in kg
} Bag;

typedef struct {
    Bag bags[MAX_BAGS];
    int front;
    int rear;
    int count;
} BaggageQueue;

void initializeQueue(BaggageQueue *queue) {
    queue->front = 0;
    queue->rear = -1;
    queue->count = 0;
}

int isFull(BaggageQueue *queue) {
    return queue->count == MAX_BAGS;
}

int isEmpty(BaggageQueue *queue) {
    return queue->count == 0;
}

void enqueue(BaggageQueue *queue, Bag bag) {
    if (isFull(queue)) {
        printf("Baggage Queue is full! Cannot add bag ID: %d\n", bag.id);
        return;
    }
    queue->rear = (queue->rear + 1) % MAX_BAGS;
    queue->bags[queue->rear] = bag;
    queue->count++;
}

Bag dequeue(BaggageQueue *queue) {
    if (isEmpty(queue)) {
        printf("Baggage Queue is empty! No bag to process.\n");
        Bag emptyBag = {0, "", 0};
        return emptyBag;
    }
    Bag bag = queue->bags[queue->front];
    queue->front = (queue->front + 1) % MAX_BAGS;
    queue->count--;
    return bag;
}

void printBag(Bag bag) {
    if (bag.weight > 0) {
        printf("Processing Bag ID: %d, Type: %s, Weight: %d kg\n", bag.id, bag.type, bag.weight);
    }
}

void processBaggage(BaggageQueue *queue) {
    while (!isEmpty(queue)) {
        Bag bag = dequeue(queue);
        sleep(1); // Simulate processing time for each bag
        printBag(bag);
    }
    printf("All bags have been processed.\n");
}

int main() {
    BaggageQueue queue;
    initializeQueue(&queue);

    for (int i = 1; i <= 10; ++i) {
        Bag bag;
        bag.id = i;
        snprintf(bag.type, BAGGAGE_TYPE_LEN, "BagType%d", i);
        bag.weight = rand() % (BAGGAGE_MAX_WEIGHT + 1); // Weight from 0 to 30 kg
        printf("Adding Bag ID: %d, Type: %s, Weight: %d kg to queue...\n", bag.id, bag.type, bag.weight);
        enqueue(&queue, bag);
    }

    printf("Starting baggage processing...\n");
    processBaggage(&queue);

    return 0;
}