//GEMINI-pro DATASET v1.0 Category: Pattern printing ; Style: distributed
#include <stdio.h>
#include <stdlib.h>

// Function to print a hollow square of side length n
void printHollowSquare(int n)
{
    int i, j;

    // Iterate over each row
    for (i = 0; i < n; i++)
    {
        // Iterate over each column
        for (j = 0; j < n; j++)
        {
            // If it is the first or last row or column, print a star
            if (i == 0 || i == n - 1 || j == 0 || j == n - 1)
                printf("*");
            else
                printf(" ");
        }

        // Move to the next line
        printf("\n");
    }
}

// Function to print a solid square of side length n
void printSolidSquare(int n)
{
    int i, j;

    // Iterate over each row
    for (i = 0; i < n; i++)
    {
        // Iterate over each column
        for (j = 0; j < n; j++)
        {
            // Print a star
            printf("*");
        }

        // Move to the next line
        printf("\n");
    }
}

// Function to print a right triangle of height n
void printRightTriangle(int n)
{
    int i, j;

    // Iterate over each row
    for (i = 0; i < n; i++)
    {
        // Iterate over each column
        for (j = 0; j <= i; j++)
        {
            // Print a star
            printf("*");
        }

        // Move to the next line
        printf("\n");
    }
}

// Function to print a left triangle of height n
void printLeftTriangle(int n)
{
    int i, j;

    // Iterate over each row
    for (i = 0; i < n; i++)
    {
        // Iterate over each column
        for (j = 0; j < n - i; j++)
        {
            // Print a star
            printf("*");
        }

        // Move to the next line
        printf("\n");
    }
}

// Function to print a diamond of height n
void printDiamond(int n)
{
    // Print the upper half of the diamond
    for (int i = 0; i < n; i++)
    {
        // Print spaces for the left side
        for (int j = 0; j < n - i - 1; j++)
        {
            printf(" ");
        }

        // Print stars for the current row
        for (int j = 0; j < 2 * i + 1; j++)
        {
            printf("*");
        }

        // Move to the next line
        printf("\n");
    }

    // Print the lower half of the diamond
    for (int i = n - 1; i >= 0; i--)
    {
        // Print spaces for the left side
        for (int j = 0; j < n - i - 1; j++)
        {
            printf(" ");
        }

        // Print stars for the current row
        for (int j = 0; j < 2 * i + 1; j++)
        {
            printf("*");
        }

        // Move to the next line
        printf("\n");
    }
}

// Function to print a Christmas tree of height n
void printChristmasTree(int n)
{
    // Print the trunk of the tree
    for (int i = 0; i < n; i++)
    {
        // Print spaces for the left side
        for (int j = 0; j < n - i - 1; j++)
        {
            printf(" ");
        }

        // Print stars for the current row
        for (int j = 0; j < 2 * i + 1; j++)
        {
            printf("*");
        }

        // Move to the next line
        printf("\n");
    }

    // Print the base of the tree
    for (int i = 0; i < 2; i++)
    {
        // Print spaces for the left side
        for (int j = 0; j < n - 2; j++)
        {
            printf(" ");
        }

        // Print stars for the current row
        for (int j = 0; j < 5; j++)
        {
            printf("*");
        }

        // Move to the next line
        printf("\n");
    }
}

// Main function
int main()
{
    // Print a hollow square of side length 5
    printf("Hollow square of side length 5:\n");
    printHollowSquare(5);
    printf("\n");

    // Print a solid square of side length 5
    printf("Solid square of side length 5:\n");
    printSolidSquare(5);
    printf("\n");

    // Print a right triangle of height 5
    printf("Right triangle of height 5:\n");
    printRightTriangle(5);
    printf("\n");

    // Print a left triangle of height 5
    printf("Left triangle of height 5:\n");
    printLeftTriangle(5);
    printf("\n");

    // Print a diamond of height 5
    printf("Diamond of height 5:\n");
    printDiamond(5);
    printf("\n");

    // Print a Christmas tree of height 5
    printf("Christmas tree of height 5:\n");
    printChristmasTree(5);

    return 0;
}