//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: portable
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESSES 5

struct process {
    int process_id;
    int arrival_time;
    int burst_time;
    int waiting_time;
    int turnaround_time;
};

void calculate_waiting_time(struct process *processes) {
    int i;
    for (i = 0; i < MAX_PROCESSES; i++) {
        processes[i].waiting_time = processes[i].arrival_time - processes[i].burst_time;
    }
}

void calculate_turnaround_time(struct process *processes) {
    int i;
    for (i = 0; i < MAX_PROCESSES; i++) {
        processes[i].turnaround_time = processes[i].waiting_time + processes[i].burst_time;
    }
}

int main() {
    struct process processes[MAX_PROCESSES];

    // Populate the processes array
    processes[0].process_id = 1;
    processes[0].arrival_time = 0;
    processes[0].burst_time = 5;

    processes[1].process_id = 2;
    processes[1].arrival_time = 2;
    processes[1].burst_time = 4;

    processes[2].process_id = 3;
    processes[2].arrival_time = 3;
    processes[2].burst_time = 3;

    processes[3].process_id = 4;
    processes[3].arrival_time = 4;
    processes[3].burst_time = 2;

    processes[4].process_id = 5;
    processes[4].arrival_time = 5;
    processes[4].burst_time = 1;

    // Calculate waiting time and turnaround time
    calculate_waiting_time(processes);
    calculate_turnaround_time(processes);

    // Print the results
    printf("Process ID\tArrival Time\tBurst Time\tWaiting Time\tTurnaround Time\n");
    for (int i = 0; i < MAX_PROCESSES; i++) {
        printf("%d\t%d\t%d\t%d\t%d\n", processes[i].process_id, processes[i].arrival_time, processes[i].burst_time, processes[i].waiting_time, processes[i].turnaround_time);
    }

    return 0;
}