//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define MAX_MSG_SIZE 100
#define MSG_QUEUE_KEY 1234

typedef struct msg_buffer {
    long mtype;
    char mtext[MAX_MSG_SIZE];
} msg_buffer;

int main() {
    int msg_queue_id;
    key_t msg_queue_key = MSG_QUEUE_KEY;
    int msg_size;

    // Creating a message queue
    msg_queue_id = msgget(msg_queue_key, 0666 | IPC_CREAT);
    if (msg_queue_id == -1) {
        printf("Error creating message queue.\n");
        exit(1);
    }

    // Sending message to the queue
    msg_size = strlen("Hello, World! ");
    msg_buffer msg;
    strcpy(msg.mtext, "Hello, World! ");
    msg.mtype = 1;
    if (msgsnd(msg_queue_id, &msg, msg_size, 0) == -1) {
        printf("Error sending message to queue.\n");
        exit(1);
    }

    // Receiving message from the queue
    msg_buffer received_msg;
    msg_size = sizeof(received_msg);
    if (msgrcv(msg_queue_id, &received_msg, msg_size, 1, 0) == -1) {
        printf("Error receiving message from queue.\n");
        exit(1);
    }

    printf("Received message: %s\n", received_msg.mtext);

    // Deleting the message queue
    if (msgctl(msg_queue_id, IPC_RMID, NULL) == -1) {
        printf("Error deleting message queue.\n");
        exit(1);
    }

    return 0;
}