//GEMINI-pro DATASET v1.0 Category: Text processing ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Function to print the longest word in a string
void printLongestWord(char *str)
{
    int i, start = 0, end = 0, maxLen = 0;

    // Iterate over the string
    for (i = 0; str[i] != '\0'; i++)
    {
        // If the current character is a space
        if (str[i] == ' ')
        {
            // Update the maximum length and the start and end indices of the longest word
            if (i - start > maxLen)
            {
                maxLen = i - start;
                end = i - 1;
            }

            // Reset the start index to the next character after the space
            start = i + 1;
        }
    }

    // Check if the last word is the longest word
    if (i - start > maxLen)
    {
        maxLen = i - start;
        end = i - 1;
    }

    // Print the longest word
    for (i = start; i <= end; i++)
    {
        printf("%c", str[i]);
    }
}

// Function to count the number of words in a string
int countWords(char *str)
{
    int count = 0;

    // Iterate over the string
    for (int i = 0; str[i] != '\0'; i++)
    {
        // If the current character is a space
        if (str[i] == ' ')
        {
            // Increment the word count
            count++;
        }
    }

    // Return the word count
    return count + 1;
}

// Function to reverse a string
void reverseString(char *str)
{
    int i, len = strlen(str);

    // Iterate over the string
    for (i = 0; i < len / 2; i++)
    {
        // Swap the characters at indices i and len - i - 1
        char temp = str[i];
        str[i] = str[len - i - 1];
        str[len - i - 1] = temp;
    }
}

// Function to print the frequency of each character in a string
void printCharacterFrequency(char *str)
{
    int i, j, count;

    // Create an array to store the frequency of each character
    int frequency[256] = {0};

    // Iterate over the string
    for (i = 0; str[i] != '\0'; i++)
    {
        // Increment the frequency of the current character
        frequency[str[i]]++;
    }

    // Iterate over the array
    for (i = 0; i < 256; i++)
    {
        // If the frequency of the current character is greater than 0
        if (frequency[i] > 0)
        {
            // Print the character and its frequency
            printf("%c: %d\n", i, frequency[i]);
        }
    }
}

// Function to remove all spaces from a string
void removeSpaces(char *str)
{
    int i, j = 0;

    // Iterate over the string
    for (i = 0; str[i] != '\0'; i++)
    {
        // If the current character is not a space
        if (str[i] != ' ')
        {
            // Copy the character to the new string
            str[j++] = str[i];
        }
    }

    // Terminate the new string
    str[j] = '\0';
}

// Function to replace all occurrences of a character in a string
void replaceCharacter(char *str, char oldChar, char newChar)
{
    int i;

    // Iterate over the string
    for (i = 0; str[i] != '\0'; i++)
    {
        // If the current character is the old character
        if (str[i] == oldChar)
        {
            // Replace the old character with the new character
            str[i] = newChar;
        }
    }
}

int main()
{
    // Example string
    char str[] = "The quick brown fox jumps over the lazy dog";

    // Print the longest word in the string
    printf("Longest word: ");
    printLongestWord(str);
    printf("\n");

    // Count the number of words in the string
    printf("Number of words: %d\n", countWords(str));

    // Reverse the string
    reverseString(str);
    printf("Reversed string: %s\n", str);

    // Print the frequency of each character in the string
    printf("Character frequency:\n");
    printCharacterFrequency(str);

    // Remove all spaces from the string
    removeSpaces(str);
    printf("String without spaces: %s\n", str);

    // Replace all occurrences of 'o' with 'a' in the string
    replaceCharacter(str, 'o', 'a');
    printf("String with 'o' replaced with 'a': %s\n", str);

    return 0;
}