//Falcon-180B DATASET v1.0 Category: Data structures visualization ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define a structure for a student
typedef struct {
    char name[50];
    int age;
    int roll_no;
} Student;

// Function to add a new student to the list
void add_student(Student *list, int size, int capacity, char name[], int age, int roll_no) {
    // Check if the list is full
    if (size == capacity) {
        printf("Error: List is full\n");
        return;
    }

    // Add the new student to the list
    strcpy(list[size].name, name);
    list[size].age = age;
    list[size].roll_no = roll_no;
    size++;
}

// Function to remove a student from the list
void remove_student(Student *list, int size, int capacity, char name[]) {
    // Search for the student in the list
    for (int i = 0; i < size; i++) {
        if (strcmp(list[i].name, name) == 0) {
            // Remove the student from the list
            for (int j = i; j < size - 1; j++) {
                list[j] = list[j + 1];
            }
            size--;
            return;
        }
    }
}

// Function to display the list of students
void display_students(Student *list, int size) {
    printf("Name\tAge\tRoll No\n");
    for (int i = 0; i < size; i++) {
        printf("%s\t%d\t%d\n", list[i].name, list[i].age, list[i].roll_no);
    }
}

int main() {
    // Initialize the list of students
    Student list[100];
    int size = 0;
    int capacity = 100;

    // Add some students to the list
    add_student(list, size, capacity, "John", 20, 101);
    add_student(list, size, capacity, "Jane", 22, 102);
    add_student(list, size, capacity, "Bob", 21, 103);

    // Display the list of students
    display_students(list, size);

    // Remove a student from the list
    remove_student(list, size, capacity, "Bob");

    // Display the updated list of students
    display_students(list, size);

    return 0;
}