//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// You see, the invaders came to Earth with a mission. They wanted to conquer and enslave our planet. However, they made a mistake. They underestimated the power of human ingenuity. Our programmers were ready for them and they created CPU Scheduling Algorithms. These algorithms decided which program would run on a CPU at any given time. And guess what? The invaders didn't see that coming.

// We are going to create a simulation that shows how CPU Scheduling Algorithms work. We will create a list of programs that the invaders want to run. Each program will have a name, a priority, and an execution time.

// Now, I, the narrator, am going to talk like a drill sergeant, because that's how serious this is.

typedef struct program
{
  char *name;
  int priority;
  int executionTime;
} program;

// Let's create a list of programs that the invaders want to run.

program programs[] = {
  {"Program 1", 1, 10},
  {"Program 2", 2, 20},
  {"Program 3", 3, 30},
  {"Program 4", 4, 40},
  {"Program 5", 5, 50},
};

// We will use the First-Come, First-Served (FCFS) scheduling algorithm. This algorithm runs programs in the order they arrive. It's like a queue at the grocery store.

void fcfs()
{
  int i;

  // Invoke the drill sergeant narrator
  printf("Listen up, maggots! We're going to run these programs in FCFS order. That means the first program in line gets to run first. No exceptions!\n\n");

  // Let's run the programs.
  for (i = 0; i < 5; i++)
  {
    printf("Running program %s for %d seconds.\n", programs[i].name, programs[i].executionTime);
    sleep(programs[i].executionTime);
  }
}

// We will also use the Shortest-Job-First (SJF) scheduling algorithm. This algorithm runs the program with the shortest execution time first. It's like giving priority to the program that will take the least amount of time to run.

void sjf()
{
  int i, j, minIndex;
  program temp;

  // Invoke the drill sergeant narrator
  printf("Listen up, maggots! We're going to run these programs in SJF order. That means the program with the shortest execution time gets to run first. No exceptions!\n\n");

  // Let's sort the programs by their execution time.
  for (i = 0; i < 5; i++)
  {
    minIndex = i;
    for (j = i + 1; j < 5; j++)
    {
      if (programs[j].executionTime < programs[minIndex].executionTime)
      {
        minIndex = j;
      }
    }

    // Swap the programs.
    if (minIndex != i)
    {
      temp = programs[i];
      programs[i] = programs[minIndex];
      programs[minIndex] = temp;
    }
  }

  // Let's run the programs.
  for (i = 0; i < 5; i++)
  {
    printf("Running program %s for %d seconds.\n", programs[i].name, programs[i].executionTime);
    sleep(programs[i].executionTime);
  }
}

// We can add more scheduling algorithms here, but for now, let's just stick with FCFS and SJF.

int main()
{
  // Let's run the simulation.
  fcfs();
  printf("\n\n");
  sjf();

  return 0;
}