//Falcon-180B DATASET v1.0 Category: TCP/IP Programming ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define BUFFER_SIZE 1024

int main(int argc, char *argv[]) {
    int sockfd;
    struct sockaddr_in server_addr;
    char *message = "Hello, World! ";
    int n;

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Set server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(12345);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    // Connect to server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    // Send message
    n = send(sockfd, message, strlen(message), 0);
    if (n == -1) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    // Receive response
    char buffer[BUFFER_SIZE];
    n = recv(sockfd, buffer, BUFFER_SIZE, 0);
    if (n == -1) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Server response: %s\n", buffer);

    // Close socket
    close(sockfd);

    return 0;
}