//Falcon-180B DATASET v1.0 Category: Graph Coloring Problem ; Style: Cryptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_V 100
#define MAX_E 500
#define MAX_C 7

typedef struct {
    int v;
    int w;
} Edge;

typedef struct {
    int v;
    int color;
} Vertex;

Edge graph[MAX_E];
Vertex color[MAX_V];

int n, m;

void init() {
    srand(time(NULL));
    for (int i = 0; i < MAX_V; i++) {
        color[i].v = i;
        color[i].color = rand() % MAX_C;
    }
    n = 6;
    m = 9;
    graph[0].v = 0;
    graph[0].w = 1;
    graph[1].v = 0;
    graph[1].w = 2;
    graph[2].v = 1;
    graph[2].w = 2;
    graph[3].v = 2;
    graph[3].w = 3;
    graph[4].v = 2;
    graph[4].w = 4;
    graph[5].v = 3;
    graph[5].w = 4;
    graph[6].v = 3;
    graph[6].w = 5;
    graph[7].v = 4;
    graph[7].w = 5;
    graph[8].v = 5;
    graph[8].w = 5;
}

void print_graph() {
    for (int i = 0; i < n; i++) {
        printf("%d ", i);
    }
    printf("\n");
    for (int i = 0; i < m; i++) {
        printf("%d %d\n", graph[i].v, graph[i].w);
    }
}

int is_safe(int v, int c) {
    for (int i = 0; i < n; i++) {
        if (graph[i].v == v && color[i].color == c) {
            return 0;
        }
        if (graph[i].w == v && color[graph[i].v].color == c) {
            return 0;
        }
    }
    return 1;
}

void color_graph() {
    int c = 0;
    for (int i = 0; i < n; i++) {
        if (color[i].color == -1) {
            color[i].color = c++;
        }
    }
}

int main() {
    init();
    print_graph();
    color_graph();
    printf("Vertex\tColor\n");
    for (int i = 0; i < n; i++) {
        printf("%d\t%d\n", color[i].v, color[i].color);
    }
    return 0;
}