//Falcon2-11B DATASET v1.0 Category: Elevator Simulation ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

// Define the elevator structure
struct Elevator {
    int floor;
    int max_floor;
    int current_floor;
    int current_direction;
    int elevator_state;
};

// Function to initialize an elevator
void initializeElevator(struct Elevator* elevator, int floor, int max_floor) {
    elevator->floor = floor;
    elevator->max_floor = max_floor;
    elevator->current_floor = floor;
    elevator->current_direction = 1;
    elevator->elevator_state = 0;
}

// Function to print the current state of the elevator
void printElevatorState(struct Elevator* elevator) {
    printf("Current floor: %d\n", elevator->current_floor);
    printf("Current direction: %d\n", elevator->current_direction);
    printf("Elevator state: %d\n", elevator->elevator_state);
}

// Function to move the elevator up or down
void moveElevator(struct Elevator* elevator) {
    if (elevator->current_direction == 1) {
        elevator->current_floor += 1;
        elevator->elevator_state = 0;
    } else {
        elevator->current_floor -= 1;
        elevator->elevator_state = 1;
    }
}

// Function to simulate the elevator
void simulateElevator(struct Elevator* elevator, int num_floors) {
    int floor = 0;
    int direction = 1;
    int state = 0;
    int num_passengers = 0;

    for (int i = 0; i < num_floors; i++) {
        printf("Floor %d\n", i + 1);

        if (state == 0) {
            moveElevator(elevator);
            printf("Elevator moved up.\n");
        } else if (state == 1) {
            moveElevator(elevator);
            printf("Elevator moved down.\n");
        } else if (num_passengers > 0) {
            printf("Waiting for passengers.\n");
        } else {
            printf("No passengers in the elevator.\n");
        }

        if (floor == elevator->max_floor) {
            printf("Elevator arrived at the top floor.\n");
            break;
        }

        floor += 1;
        num_passengers = 0;
        direction = 1;
        state = 0;
    }
}

// Function to run the simulation
void runElevatorSimulation(int num_floors, int num_passengers) {
    srand(time(NULL));

    struct Elevator elevator;
    initializeElevator(&elevator, 0, num_floors);

    simulateElevator(&elevator, num_floors);

    printf("Total number of passengers: %d\n", num_passengers);
}

int main() {
    int num_floors = 10;
    int num_passengers = 3;

    runElevatorSimulation(num_floors, num_passengers);

    return 0;
}