//Code Llama-13B DATASET v1.0 Category: Password Strength Checker ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define PASSWORD_LENGTH 12
#define UPPERCASE_CHARS 4
#define LOWERCASE_CHARS 4
#define DIGITS 4
#define SPECIAL_CHARS 4

bool check_password_strength(char *password) {
    int password_length = strlen(password);
    if (password_length < PASSWORD_LENGTH) {
        return false;
    }

    int uppercase_count = 0;
    int lowercase_count = 0;
    int digit_count = 0;
    int special_count = 0;

    for (int i = 0; i < password_length; i++) {
        if (isupper(password[i])) {
            uppercase_count++;
        } else if (islower(password[i])) {
            lowercase_count++;
        } else if (isdigit(password[i])) {
            digit_count++;
        } else {
            special_count++;
        }
    }

    if (uppercase_count < UPPERCASE_CHARS || lowercase_count < LOWERCASE_CHARS || digit_count < DIGITS || special_count < SPECIAL_CHARS) {
        return false;
    }

    return true;
}

int main() {
    char password[PASSWORD_LENGTH + 1];
    printf("Enter your password: ");
    fgets(password, sizeof(password), stdin);

    if (check_password_strength(password)) {
        printf("Your password is strong!\n");
    } else {
        printf("Your password is weak!\n");
    }

    return 0;
}