//GEMINI-pro DATASET v1.0 Category: Appointment Scheduler ; Style: relaxed
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// Define the maximum number of appointments
#define MAX_APPOINTMENTS 100

// Define the structure of an appointment
typedef struct Appointment {
    char time[20];
    char description[50];
} Appointment;

// Define the array of appointments
Appointment appointments[MAX_APPOINTMENTS];

// Declare the global variables
int numAppointments = 0;

// Function to add an appointment
void addAppointment(char *time, char *description) {
    // Check if the array of appointments is full
    if (numAppointments == MAX_APPOINTMENTS) {
        printf("Error: The array of appointments is full.\n");
        return;
    }

    // Copy the time and description into the next available appointment
    strcpy(appointments[numAppointments].time, time);
    strcpy(appointments[numAppointments].description, description);

    // Increment the number of appointments
    numAppointments++;
}

// Function to print the appointments
void printAppointments() {
    // Iterate over the array of appointments
    for (int i = 0; i < numAppointments; i++) {
        // Print the time and description of each appointment
        printf("%s %s\n", appointments[i].time, appointments[i].description);
    }
}

// Function to delete an appointment
void deleteAppointment(char *time) {
    // Find the index of the appointment to be deleted
    int index = -1;
    for (int i = 0; i < numAppointments; i++) {
        if (strcmp(appointments[i].time, time) == 0) {
            index = i;
            break;
        }
    }

    // Check if the appointment was found
    if (index == -1) {
        printf("Error: The appointment was not found.\n");
        return;
    }

    // Shift the remaining appointments down one
    for (int i = index; i < numAppointments - 1; i++) {
        appointments[i] = appointments[i + 1];
    }

    // Decrement the number of appointments
    numAppointments--;
}

// Main function
int main() {
    // Add some sample appointments
    addAppointment("9:00 AM", "Doctor's appointment");
    addAppointment("10:00 AM", "Meeting with the boss");
    addAppointment("11:00 AM", "Lunch with a friend");

    // Print the appointments
    printf("Appointments:\n");
    printAppointments();

    // Delete an appointment
    deleteAppointment("10:00 AM");

    // Print the appointments again
    printf("\nAppointments after deleting 10:00 AM:\n");
    printAppointments();

    return 0;
}