//Falcon-180B DATASET v1.0 Category: Database querying ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sqlite3.h>

#define MAX_QUERY_LENGTH 1000

enum {
    COL_ID,
    COL_NAME,
    COL_AGE,
    COL_GENDER,
    COL_EMAIL,
    NUM_COLS
};

static int callback(void* data, int argc, char** argv, char** azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

static char* errMsg = NULL;

static void logError(sqlite3* db) {
    fprintf(stderr, "Error: %s\n", errMsg);
    sqlite3_free(errMsg);
    errMsg = NULL;
}

int main() {
    sqlite3* db;
    char* zErrMsg = 0;
    int rc;

    rc = sqlite3_open("test.db", &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    char* sql = "CREATE TABLE IF NOT EXISTS users(" \
                "id INTEGER PRIMARY KEY," \
                "name TEXT NOT NULL," \
                "age INTEGER NOT NULL," \
                "gender TEXT NOT NULL," \
                "email TEXT);";

    char* errMsg = 0;
    rc = sqlite3_exec(db, sql, NULL, NULL, &errMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Table created successfully\n");
    }

    sqlite3_close(db);
    return 0;
}