//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CARS 10
#define MAX_LANE 3

struct car {
  int lane;
  int position;
  int speed;
  int direction;
};

void simulate_traffic(struct car cars[], int num_cars) {
  for (int i = 0; i < num_cars; i++) {
    cars[i].position++;
    switch (cars[i].direction) {
      case 0: // Eastbound
        if (cars[i].position >= MAX_LANE) {
          cars[i].direction = 1; // Turn north
        }
        break;
      case 1: // Northbound
        if (cars[i].position >= MAX_CARS) {
          cars[i].direction = 2; // Turn west
        }
        break;
      case 2: // Westbound
        if (cars[i].position <= 0) {
          cars[i].direction = 0; // Turn south
        }
        break;
      case 3: // Southbound
        if (cars[i].position <= MAX_LANE - 1) {
          cars[i].direction = 2; // Turn west
        }
        break;
    }
  }
}

int main() {
  struct car cars[MAX_CARS];
  int num_cars = 5;

  for (int i = 0; i < num_cars; i++) {
    cars[i].lane = rand() % MAX_LANE;
    cars[i].position = rand() % MAX_CARS;
    cars[i].speed = rand() % 5;
    cars[i].direction = rand() % 4;
  }

  simulate_traffic(cars, num_cars);

  for (int i = 0; i < num_cars; i++) {
    printf("Car %d: lane %d, position %d, speed %d, direction %d\n", i + 1, cars[i].lane, cars[i].position, cars[i].speed, cars[i].direction);
  }

  return 0;
}