//GPT-4o-mini DATASET v1.0 Category: Wireless Network Scanner ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <string.h>
#include <netinet/ether.h>
#include <arpa/inet.h>

#define SNAP_LEN 1518  // maximum number of bytes to capture
#define WIRELESS_TYPE 0x00

// Function to handle captured packets
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ether_header *eth_header;
    const u_char *data;
    unsigned short eth_type;

    eth_header = (struct ether_header *) packet;
    eth_type = ntohs(eth_header->ether_type);

    // Check if packet is an 802.11 wireless frame
    if (eth_type == WIRELESS_TYPE) {
        data = packet + sizeof(struct ether_header);

        // Print source MAC address and extracted data (SSID if present)
        printf("Captured packet from: %02x:%02x:%02x:%02x:%02x:%02x\n",
               eth_header->ether_shost[0], eth_header->ether_shost[1],
               eth_header->ether_shost[2], eth_header->ether_shost[3],
               eth_header->ether_shost[4], eth_header->ether_shost[5]);

        // Here we would typically process the data further to extract SSID
        // For demonstration purposes, we are keeping it simple.

        printf("Packet data captured, length: %d bytes\n", header->len);
    }
}

// Main function for scanning networks
int main(int argc, char *argv[]) {
    pcap_t *handle;                   // Session handle
    char *device;                     // Network device to capture from
    char errbuf[PCAP_ERRBUF_SIZE];    // Error string

    if (argc != 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return EXIT_FAILURE;
    }

    device = argv[1];

    // Open the capture device
    handle = pcap_open_live(device, SNAP_LEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Couldn't open device %s: %s\n", device, errbuf);
        return EXIT_FAILURE;
    }

    // Start packet processing loop
    pcap_loop(handle, 0, packet_handler, NULL);

    // Close the session
    pcap_close(handle);
    return EXIT_SUCCESS;
}