//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DAYS 7

typedef struct {
    float temperature; // in degrees Celsius
    float humidity;    // in percentage
    float windSpeed;   // in km/h
} WeatherData;

void generateWeatherData(WeatherData *data);
void displayWeatherData(const WeatherData *data);
void analyzeWeatherData(const WeatherData *data);
float calculateAverageTemperature(const WeatherData *data);
float determineMostCommonCondition(const WeatherData *data);

int main() {
    srand(time(NULL)); // Seed the random number generator
    WeatherData weather[DAYS];

    // Generate weather data for the specified number of days
    for (int i = 0; i < DAYS; i++) {
        generateWeatherData(&weather[i]);
    }

    // Display the generated weather data
    printf("Weather Data for the next %d days:\n", DAYS);
    displayWeatherData(weather);
    
    // Analyze the weather data
    analyzeWeatherData(weather);

    return 0;
}

void generateWeatherData(WeatherData *data) {
    data->temperature = (rand() % 401 - 200) / 10.0; // Random temperature between -20.0 and 20.0°C
    data->humidity = rand() % 101; // Random humidity between 0% and 100%
    data->windSpeed = (rand() % 101); // Random wind speed between 0 and 100 km/h
}

void displayWeatherData(const WeatherData *data) {
    printf("Day\tTemperature (°C)\tHumidity (%%)\tWind Speed (km/h)\n");
    printf("---------------------------------------------------------\n");
    for (int i = 0; i < DAYS; i++) {
        printf("%d\t%.1f\t\t\t%.1f\t\t%.1f\n", i + 1, data[i].temperature, data[i].humidity, data[i].windSpeed);
    }
    printf("---------------------------------------------------------\n");
}

void analyzeWeatherData(const WeatherData *data) {
    float avgTemp = calculateAverageTemperature(data);
    printf("Average Temperature over %d days: %.2f°C\n", DAYS, avgTemp);
    float mostCommonCondition = determineMostCommonCondition(data);
    printf("Most Common Temperature Range: [%s]°C\n",
           (mostCommonCondition < 0) ? "Cold" :
           (mostCommonCondition < 15) ? "Moderate" : "Hot");
}

float calculateAverageTemperature(const WeatherData *data) {
    float totalTemp = 0.0;
    for (int i = 0; i < DAYS; i++) {
        totalTemp += data[i].temperature;
    }
    return totalTemp / DAYS;
}

float determineMostCommonCondition(const WeatherData *data) {
    int coldCount = 0, moderateCount = 0, hotCount = 0;
    
    for (int i = 0; i < DAYS; i++) {
        if (data[i].temperature < 0) {
            coldCount++;
        } else if (data[i].temperature < 15) {
            moderateCount++;
        } else {
            hotCount++;
        }
    }
    
    if (coldCount >= moderateCount && coldCount >= hotCount) {
        return -1; // Cold
    } else if (moderateCount >= coldCount && moderateCount >= hotCount) {
        return 10; // Moderate
    } else {
        return 20; // Hot
    }
}