//LLAMA2-13B DATASET v1.0 Category: Hotel Management System ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_ROOMS 100
#define MAX_GUESTS 50

// Structure to store hotel information
typedef struct {
    int num_rooms;
    int num_guests;
    int available_rooms;
    int available_guests;
    int highest_room_number;
} hotel_info_t;

// Function to initialize hotel information
void init_hotel(hotel_info_t *hotel) {
    hotel->num_rooms = 0;
    hotel->num_guests = 0;
    hotel->available_rooms = 0;
    hotel->available_guests = 0;
    hotel->highest_room_number = 0;
}

// Function to check if a room is available
int is_room_available(hotel_info_t *hotel, int room_number) {
    if (room_number > hotel->highest_room_number) {
        return 0;
    }
    if (hotel->available_rooms > 0 && hotel->available_rooms < room_number) {
        return 1;
    }
    return 0;
}

// Function to check if a guest is available
int is_guest_available(hotel_info_t *hotel, int guest_id) {
    if (guest_id > hotel->num_guests) {
        return 0;
    }
    if (hotel->available_guests > 0 && hotel->available_guests < guest_id) {
        return 1;
    }
    return 0;
}

// Function to book a room
void book_room(hotel_info_t *hotel, int room_number) {
    if (!is_room_available(hotel, room_number)) {
        printf("Sorry, there are no available rooms with that number. Please try again.\n");
        return;
    }
    hotel->available_rooms--;
    hotel->highest_room_number = room_number;
    printf("Room %d is booked. Thank you for choosing our hotel!\n", room_number);
}

// Function to check out a guest
void check_out(hotel_info_t *hotel, int guest_id) {
    if (!is_guest_available(hotel, guest_id)) {
        printf("Sorry, there is no guest with that ID. Please try again.\n");
        return;
    }
    hotel->available_guests++;
    printf("Guest %d has checked out. Thank you for staying with us!\n", guest_id);
}

// Function to display hotel information
void display_hotel_info(hotel_info_t *hotel) {
    printf("Hotel Information:\n");
    printf("-----------------\n");
    printf("Number of rooms: %d\n", hotel->num_rooms);
    printf("Number of guests: %d\n", hotel->num_guests);
    printf("Available rooms: %d\n", hotel->available_rooms);
    printf("Available guests: %d\n", hotel->available_guests);
    printf("Highest room number: %d\n", hotel->highest_room_number);
}

int main() {
    hotel_info_t hotel;
    init_hotel(&hotel);

    // Example usage of the functions
    book_room(&hotel, 10);
    book_room(&hotel, 20);
    book_room(&hotel, 30);
    check_out(&hotel, 1);
    check_out(&hotel, 2);
    check_out(&hotel, 3);

    display_hotel_info(&hotel);

    return 0;
}