//GPT-4o-mini DATASET v1.0 Category: Digital Watermarking ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 5
#define HEIGHT 5

// Function to display the image
void displayImage(int image[HEIGHT][WIDTH]) {
    printf("Image (grayscale pixels):\n");
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            printf("%3d ", image[i][j]);
        }
        printf("\n");
    }
}

// Function to embed watermark
void embedWatermark(int image[HEIGHT][WIDTH], int watermark, int position) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            // Embed watermark bit if within bounds
            int bit = (watermark >> position) & 1;
            if (bit) {
                image[i][j] |= 1; // Set LSB to 1
            } else {
                image[i][j] &= ~1; // Set LSB to 0
            }
            position++;
            if (position >= 8) { // Limit watermark bits to a byte
                return;
            }
        }
    }
}

// Function to extract watermark
int extractWatermark(int image[HEIGHT][WIDTH]) {
    int watermark = 0;
    int position = 0;

    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            int bit = image[i][j] & 1; // Get LSB
            watermark |= (bit << position);
            position++;
            if (position >= 8) { // Limit to a byte
                return watermark;
            }
        }
    }
    return watermark;
}

// Main function
int main() {
    int image[HEIGHT][WIDTH] = {
        {100, 150, 200, 255, 50},
        {20, 80, 120, 180, 220},
        {10, 40, 90, 160, 210},
        {55, 155, 30, 80, 10},
        {5, 25, 100, 70, 190}
    };

    int watermark = 5; // Example binary watermark (00000101)
    int position = 0; // Start embedding position

    printf("Original ");
    displayImage(image);

    // Embed watermark into the image
    printf("\nEmbedding watermark...\n");
    embedWatermark(image, watermark, position);
    
    printf("Image after embedding watermark:\n");
    displayImage(image);

    // Extract watermark from the image
    int extractedWatermark = extractWatermark(image);
    printf("\nExtracted watermark: %d\n", extractedWatermark);

    return 0;
}