//Gemma-7B DATASET v1.0 Category: Bingo Simulator ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_BINGO_NUM 9

typedef struct BingoCard {
  int numbers[MAX_BINGO_NUM];
  int isWon;
} BingoCard;

void generateBingoCard(BingoCard *card) {
  for (int i = 0; i < MAX_BINGO_NUM; i++) {
    card->numbers[i] = rand() % MAX_BINGO_NUM + 1;
  }
  card->isWon = 0;
}

void playBingo(BingoCard *card) {
  // Draw a number
  int numberDrawn = rand() % MAX_BINGO_NUM + 1;

  // Check if the number is on the card
  for (int i = 0; i < MAX_BINGO_NUM; i++) {
    if (card->numbers[i] == numberDrawn) {
      card->numbers[i] = -1;
    }
  }

  // Check if the card is won
  if (card->numbers[0] == -1 && card->numbers[1] == -1 && card->numbers[2] == -1) {
    card->isWon = 1;
  }
}

int main() {
  BingoCard card;
  generateBingoCard(&card);

  for (int i = 0; card.isWon == 0 && i < 10; i++) {
    playBingo(&card);
  }

  if (card.isWon) {
    printf("You won!");
  } else {
    printf("Sorry, you lost.");
  }

  return 0;
}