//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

// Defining the maximum number of tasks
#define MAX_TASKS 100

// Structure to represent a task
typedef struct Task {
    int arrival_time;
    int burst_time;
    int priority;
} Task;

// Function to compare tasks based on priority
int compare_tasks(const void *a, const void *b) {
    const Task *task1 = (const Task *)a;
    const Task *task2 = (const Task *)b;
    return task1->priority - task2->priority;
}

// Function to find the minimum arrival time among the tasks
int find_min_arrival_time(Task tasks[], int n) {
    int min_arrival_time = INT_MAX;
    for (int i = 0; i < n; i++) {
        if (tasks[i].arrival_time < min_arrival_time) {
            min_arrival_time = tasks[i].arrival_time;
        }
    }
    return min_arrival_time;
}

// Function to perform priority-based scheduling
void priority_scheduling(Task tasks[], int n) {
    // Sort the tasks based on priority
    qsort(tasks, n, sizeof(Task), compare_tasks);

    // Find the minimum arrival time
    int min_arrival_time = find_min_arrival_time(tasks, n);

    // Initialize the current time to the minimum arrival time
    int current_time = min_arrival_time;

    // Initialize the wait time for each task to 0
    int wait_time[n];
    for (int i = 0; i < n; i++) {
        wait_time[i] = 0;
    }

    // Iterate over the tasks in sorted order
    for (int i = 0; i < n; i++) {
        // If the current task has not yet arrived, wait until its arrival time
        if (tasks[i].arrival_time > current_time) {
            current_time = tasks[i].arrival_time;
        }

        // Calculate the waiting time for the current task
        wait_time[i] = current_time - tasks[i].arrival_time;

        // Increment the current time by the burst time of the current task
        current_time += tasks[i].burst_time;
    }

    // Print the waiting time for each task
    printf("Task\tArrival Time\tBurst Time\tPriority\tWaiting Time\n");
    for (int i = 0; i < n; i++) {
        printf("%d\t%d\t\t%d\t\t%d\t\t%d\n", i + 1, tasks[i].arrival_time, tasks[i].burst_time, tasks[i].priority, wait_time[i]);
    }
}

// Driver code
int main() {
    // Initialize the tasks
    Task tasks[] = {
        {0, 5, 3},
        {1, 3, 1},
        {3, 4, 2},
        {5, 2, 4},
        {6, 1, 5},
    };
    int n = sizeof(tasks) / sizeof(tasks[0]);

    // Perform priority-based scheduling
    priority_scheduling(tasks, n);

    return 0;
}