//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: romantic
// Romeo and Juliet, an Interprocess Communication (IPC) Tale

#include <stdio.h>
#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/msg.h>

// Message structure for love letters
typedef struct {
    long mtype;          // Message type (Romeo's or Juliet's)
    char message[256];   // Love letter content
} love_letter;

// Create a message queue, the balcony where Romeo and Juliet exchange messages
int create_balcony() {
    key_t key = ftok("balcony.key", 666); // Generate a unique key for the IPC
    int balcony = msgget(key, 0666 | IPC_CREAT); // Create the message queue
    if (balcony == -1) {
        perror("Could not create the balcony! Are you standing in the wrong spot?");
        exit(EXIT_FAILURE);
    }
    return balcony;
}

// Romeo's Proposal: Sending a love letter to Juliet
void romeo_proposes(int balcony) {
    love_letter proposal = {
        .mtype = 1,            // Romeo's message type
        .message = "My dearest Juliet, shall we dance beneath the moonlit stars?"
    };
    if (msgsnd(balcony, &proposal, sizeof(proposal), 0) == -1) {
        perror("Romeo's proposal got lost in the wind!");
        exit(EXIT_FAILURE);
    }
    printf("Romeo: I've sent my heart's desire to Juliet!\n");
}

// Juliet's Response: Reading Romeo's letter and replying
void juliet_responds(int balcony) {
    love_letter response;
    if (msgrcv(balcony, &response, sizeof(response), 1, 0) == -1) {
        perror("Juliet's response was blown away by the wind!");
        exit(EXIT_FAILURE);
    }
    printf("Juliet: Romeo's words ignite a flame within me!\n");
    love_letter reply = {
        .mtype = 2,            // Juliet's message type
        .message = "Yes, Romeo, my love knows no bounds!"
    };
    if (msgsnd(balcony, &reply, sizeof(reply), 0) == -1) {
        perror("Juliet's reply got lost in the night!");
        exit(EXIT_FAILURE);
    }
    printf("Juliet: I've sent my reply, a beacon of love to my beloved.\n");
}

int main() {
    int balcony = create_balcony();
    romeo_proposes(balcony);
    juliet_responds(balcony);
    printf("Romeo and Juliet's love has blossomed through the balcony of IPC!\n");
    return EXIT_SUCCESS;
}