//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: Cyberpunk
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

typedef struct {
    float x;
    float y;
} Vec2;

Vec2 vec2_add(Vec2 a, Vec2 b) {
    return (Vec2) {a.x + b.x, a.y + b.y};
}

Vec2 vec2_sub(Vec2 a, Vec2 b) {
    return (Vec2) {a.x - b.x, a.y - b.y};
}

Vec2 vec2_scale(Vec2 a, float scalar) {
    return (Vec2) {a.x * scalar, a.y * scalar};
}

float vec2_dot(Vec2 a, Vec2 b) {
    return a.x * b.x + a.y * b.y;
}

float vec2_length(Vec2 a) {
    return sqrtf(vec2_dot(a, a));
}

Vec2 vec2_normalize(Vec2 a) {
    float length = vec2_length(a);
    if (length == 0.0f) {
        return (Vec2) {0.0f, 0.0f};
    }
    return vec2_scale(a, 1.0f / length);
}

int main() {
    // Initialize a vector
    Vec2 v = {1.0f, 2.0f};

    // Add two vectors
    Vec2 v_add = vec2_add(v, (Vec2) {3.0f, 4.0f});

    // Subtract two vectors
    Vec2 v_sub = vec2_sub(v, (Vec2) {3.0f, 4.0f});

    // Scale a vector
    Vec2 v_scale = vec2_scale(v, 2.0f);

    // Dot product of two vectors
    float v_dot = vec2_dot(v, (Vec2) {3.0f, 4.0f});

    // Length of a vector
    float v_length = vec2_length(v);

    // Normalize a vector
    Vec2 v_norm = vec2_normalize(v);

    // Print the results
    printf("Original vector: (%f, %f)\n", v.x, v.y);
    printf("Added vector: (%f, %f)\n", v_add.x, v_add.y);
    printf("Subtracted vector: (%f, %f)\n", v_sub.x, v_sub.y);
    printf("Scaled vector: (%f, %f)\n", v_scale.x, v_scale.y);
    printf("Dot product: %f\n", v_dot);
    printf("Length: %f\n", v_length);
    printf("Normalized vector: (%f, %f)\n", v_norm.x, v_norm.y);

    return 0;
}