//LLAMA2-13B DATASET v1.0 Category: Spell checking ; Style: detailed
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define MAGIC_WORD "MAGICAL_SPELL_CHECKER"

// Function to check if a word is a misspelling
int is_misspelling(const char* word) {
    int i, j, k;
    for (i = 0; i < strlen(word); i++) {
        for (j = 0; j < strlen(word); j++) {
            for (k = 0; k < strlen(word); k++) {
                if (word[i] == word[j] && word[i] == word[k]) {
                    // If the word contains 3 or more consecutive identical letters, it's a misspelling
                    return 1;
                }
            }
        }
    }
    return 0;
}

// Function to check if a word is a correct spelling
int is_correct_spelling(const char* word) {
    int i, j, k;
    for (i = 0; i < strlen(word); i++) {
        for (j = 0; j < strlen(word); j++) {
            for (k = 0; k < strlen(word); k++) {
                if (word[i] == word[j] && word[i] == word[k]) {
                    // If the word contains 3 or more consecutive identical letters, it's not a correct spelling
                    return 0;
                }
            }
        }
    }
    return 1;
}

// Function to check the spelling of a word
int check_spelling(const char* word) {
    int result = 0;
    if (strcmp(word, MAGIC_WORD) == 0) {
        // If the word is "MAGICAL_SPELL_CHECKER", it's a correct spelling
        result = 1;
    } else {
        // Otherwise, check if the word is a misspelling
        result = is_misspelling(word);
    }
    return result;
}

int main() {
    // Define some sample words to check
    const char* words[] = {"MAGICAL_SPELL_CHECKER", "MAGIC_SPELL_CHECKER", "MAGIC_SPEL_CHECKER", "CORRECT_SPELLING", "INCORRECT_SPELLING"};
    int i;

    // Loop through the words and print the result of the spelling check
    for (i = 0; i < sizeof(words) / sizeof(words[0]); i++) {
        printf("Word: %s, Result: %d\n", words[i], check_spelling(words[i]));
    }

    return 0;
}