//Gemma-7B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>

#define MAX_BUFFER_SIZE 1024

typedef struct Calculator {
  char buffer[MAX_BUFFER_SIZE];
  int pos;
  int state;
  double result;
} Calculator;

void calculator_init(Calculator *calc) {
  calc->pos = 0;
  calc->state = 0;
  calc->result = 0.0;
  calc->buffer[0] = '\0';
}

void calculator_add_number(Calculator *calc, int number) {
  if (calc->pos >= MAX_BUFFER_SIZE - 1) {
    return;
  }

  calc->buffer[calc->pos++] = number + '0';
  calc->buffer[calc->pos] = '\0';
}

void calculator_operator(Calculator *calc, char operator) {
  switch (operator) {
    case '+':
      calc->state = 1;
      break;
    case '-':
      calc->state = 2;
      break;
    case '*':
      calc->state = 3;
      break;
    case '/':
      calc->state = 4;
      break;
    default:
      return;
  }

  calc->buffer[calc->pos++] = operator;
  calc->buffer[calc->pos] = '\0';
}

double calculator_calculate(Calculator *calc) {
  switch (calc->state) {
    case 1:
      calc->result = atof(calc->buffer) + calc->result;
      break;
    case 2:
      calc->result = -calc->result - atof(calc->buffer);
      break;
    case 3:
      calc->result = calc->result * atof(calc->buffer);
      break;
    case 4:
      calc->result = calc->result / atof(calc->buffer);
      break;
    default:
      return 0.0;
  }

  return calc->result;
}

int main() {
  Calculator calc;
  calculator_init(&calc);

  calculator_add_number(&calc, 10);
  calculator_add_number(&calc, 20);
  calculator_operator(&calc, '+');
  calculator_add_number(&calc, 30);
  calculator_operator(&calc, '-');
  calculator_add_number(&calc, 40);
  calculator_operator(&calc, '*');
  calculator_add_number(&calc, 50);
  calculator_operator(&calc, '/');
  calculator_add_number(&calc, 60);

  double result = calculator_calculate(&calc);
  printf("The result is: %.2lf\n", result);

  return 0;
}