//Falcon-180B DATASET v1.0 Category: Building a FTP Client ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT 21
#define BUFFER_SIZE 1024

int main() {
    int sockfd;
    struct sockaddr_in server_addr;
    char buffer[BUFFER_SIZE];
    
    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        printf("Error creating socket\n");
        return 1;
    }
    
    // Initialize server address
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    // Connect to server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        printf("Error connecting to server\n");
        return 1;
    }

    // Send USER command
    strcpy(buffer, "USER anonymous\r\n");
    send(sockfd, buffer, strlen(buffer), 0);

    // Send PASS command
    strcpy(buffer, "PASS anonymous\r\n");
    send(sockfd, buffer, strlen(buffer), 0);

    // Change to passive mode
    strcpy(buffer, "PASV\r\n");
    send(sockfd, buffer, strlen(buffer), 0);

    // Receive response
    memset(buffer, 0, BUFFER_SIZE);
    if (recv(sockfd, buffer, BUFFER_SIZE, 0) == -1) {
        printf("Error receiving response\n");
        return 1;
    }
    printf("Received response: %s", buffer);

    // Close socket
    close(sockfd);

    return 0;
}