//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the size of the expense array
#define SIZE 100

typedef struct {
    char category[50];
    double amount;
} expense;

// Function prototypes
void addExpense(expense *expenses, int *size, char *category, double amount);
void displayExpenses(expense *expenses, int size);
void calculateTotal(expense *expenses, int size, double *total);

int main() {
    int size = 0;
    expense expenses[SIZE];

    // Initialize the expenses array
    for (int i = 0; i < SIZE; i++) {
        expenses[i].category[0] = '\0';
        expenses[i].amount = 0.0;
    }

    // Add some expenses
    addExpense(expenses, &size, "Groceries", 50.00);
    addExpense(expenses, &size, "Rent", 1000.00);
    addExpense(expenses, &size, "Entertainment", 25.00);

    // Display the expenses
    displayExpenses(expenses, size);

    // Calculate the total expenses
    double total = 0.0;
    calculateTotal(expenses, size, &total);
    printf("Total expenses: $%.2f\n", total);

    return 0;
}

void addExpense(expense *expenses, int *size, char *category, double amount) {
    if (*size >= SIZE) {
        printf("Error: Expense array is full.\n");
        return;
    }

    strcpy(expenses[*size].category, category);
    expenses[*size].amount = amount;
    (*size)++;
}

void displayExpenses(expense *expenses, int size) {
    printf("Expenses:\n");
    for (int i = 0; i < size; i++) {
        printf("%s: $%.2f\n", expenses[i].category, expenses[i].amount);
    }
}

void calculateTotal(expense *expenses, int size, double *total) {
    for (int i = 0; i < size; i++) {
        *total += expenses[i].amount;
    }
}