//Falcon2-11B DATASET v1.0 Category: Game of Life ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main(int argc, char *argv[]) {
    srand(time(NULL));
    int width = 8;
    int height = 8;
    int grid[width][height];
    int next_generation[width][height];

    // Populate the initial grid with random values between 0 and 1.
    for (int i = 0; i < width; i++) {
        for (int j = 0; j < height; j++) {
            grid[i][j] = rand() % 2;
        }
    }

    // Print the initial grid.
    printf("Initial Grid:\n");
    for (int i = 0; i < width; i++) {
        for (int j = 0; j < height; j++) {
            printf("%3d", grid[i][j]);
        }
        printf("\n");
    }

    // Calculate the next generation.
    for (int i = 0; i < width; i++) {
        for (int j = 0; j < height; j++) {
            int live_neighbors = 0;
            for (int k = -1; k < 2; k++) {
                for (int l = -1; l < 2; l++) {
                    if (i + k >= 0 && i + k < width && j + l >= 0 && j + l < height) {
                        if (grid[i + k][j + l] == 1) {
                            live_neighbors++;
                        }
                    }
                }
            }
            next_generation[i][j] = (grid[i][j] == 1)? (live_neighbors == 2 || live_neighbors == 3) : (live_neighbors == 3);
        }
    }

    // Print the next generation.
    printf("\nNext Generation:\n");
    for (int i = 0; i < width; i++) {
        for (int j = 0; j < height; j++) {
            printf("%3d", next_generation[i][j]);
        }
        printf("\n");
    }

    return 0;
}