//Falcon2-11B DATASET v1.0 Category: Pac-Man Game Clone ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

void initialize(int rows, int cols, int pacman_x, int pacman_y) {
    // Initialize the game board with pacman and ghosts at their starting positions
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            if (i == pacman_x && j == pacman_y) {
                printf("*");
            } else if (i == pacman_x && j == pacman_y + 1) {
                printf("@");
            } else if (i == pacman_x && j == pacman_y - 1) {
                printf("$");
            } else if (i == pacman_x + 1 && j == pacman_y) {
                printf("+");
            } else if (i == pacman_x - 1 && j == pacman_y) {
                printf("-");
            } else if (i == pacman_x + 1 && j == pacman_y + 1) {
                printf("^");
            } else if (i == pacman_x - 1 && j == pacman_y - 1) {
                printf("v");
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

void game_loop(int rows, int cols, int pacman_x, int pacman_y) {
    // Start the game loop
    int ghost_x[4] = {pacman_x - 1, pacman_x, pacman_x + 1, pacman_x + 2};
    int ghost_y[4] = {pacman_y - 1, pacman_y, pacman_y + 1, pacman_y + 2};
    srand(time(NULL));
    int ghost_direction[4] = {1, 1, 1, 1};
    int pacman_direction = 1;
    int score = 0;

    while (1) {
        if (pacman_direction == 1) {
            pacman_y--;
        } else if (pacman_direction == 2) {
            pacman_x--;
        } else if (pacman_direction == 3) {
            pacman_y++;
        } else if (pacman_direction == 4) {
            pacman_x++;
        }

        // Check for collision with ghosts
        for (int i = 0; i < 4; i++) {
            if (pacman_x == ghost_x[i] && pacman_y == ghost_y[i]) {
                printf("You have been caught by a ghost!\n");
                break;
            }
        }

        // Check for collision with walls
        if (pacman_x < 0 || pacman_x >= rows || pacman_y < 0 || pacman_y >= cols) {
            printf("You have hit a wall!\n");
            break;
        }

        // Check for collision with food
        if (pacman_x == pacman_x && pacman_y == pacman_y + 1) {
            score++;
            printf("Score: %d\n", score);
        }

        // Move ghosts
        for (int i = 0; i < 4; i++) {
            if (ghost_direction[i] == 1) {
                ghost_y[i]--;
            } else if (ghost_direction[i] == 2) {
                ghost_x[i]--;
            } else if (ghost_direction[i] == 3) {
                ghost_y[i]++;
            } else if (ghost_direction[i] == 4) {
                ghost_x[i]++;
            }

            if (ghost_x[i] < 0 || ghost_x[i] >= rows || ghost_y[i] < 0 || ghost_y[i] >= cols) {
                ghost_direction[i] = rand() % 4;
            }
        }

        // Update the game board
        printf("\n");
        for (int i = 0; i < rows; i++) {
            for (int j = 0; j < cols; j++) {
                if (i == pacman_x && j == pacman_y) {
                    printf("*");
                } else if (i == ghost_x[0] && j == ghost_y[0]) {
                    printf("@");
                } else if (i == ghost_x[1] && j == ghost_y[1]) {
                    printf("$");
                } else if (i == ghost_x[2] && j == ghost_y[2]) {
                    printf("+");
                } else if (i == ghost_x[3] && j == ghost_y[3]) {
                    printf("-");
                } else if (i == ghost_x[0] && j == ghost_y[0] + 1) {
                    printf("^");
                } else if (i == ghost_x[1] && j == ghost_y[1] + 1) {
                    printf("v");
                } else {
                    printf(" ");
                }
            }
            printf("\n");
        }

        printf("Press any key to continue...\n");
        getchar();
    }
}

int main() {
    // Set the number of rows and columns for the game board
    int rows = 10;
    int cols = 10;

    // Set the initial position of pacman
    int pacman_x = 5;
    int pacman_y = 5;

    // Initialize the game board
    initialize(rows, cols, pacman_x, pacman_y);

    // Start the game loop
    game_loop(rows, cols, pacman_x, pacman_y);

    return 0;
}