//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: Cryptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 100

typedef struct {
    char name[MAX_SIZE];
    int quantity;
    float price;
} Item;

typedef struct {
    int top;
    int capacity;
    Item items[MAX_SIZE];
} Stack;

void push(Stack* stack, Item item) {
    if (stack->top == stack->capacity) {
        printf("Stack overflow\n");
        return;
    }
    stack->items[++stack->top] = item;
}

Item pop(Stack* stack) {
    if (stack->top == -1) {
        printf("Stack underflow\n");
        return (Item){ 0 };
    }
    return stack->items[stack->top--];
}

int is_empty(Stack* stack) {
    return stack->top == -1;
}

int is_full(Stack* stack) {
    return stack->top == stack->capacity;
}

void init_stack(Stack* stack) {
    stack->top = -1;
    stack->capacity = MAX_SIZE;
}

void print_item(Item item) {
    printf("%s - %d units - $%.2f\n", item.name, item.quantity, item.price);
}

int main() {
    Stack inventory;
    init_stack(&inventory);

    push(&inventory, (Item){.name = "Widget",.quantity = 50,.price = 5.99 });
    push(&inventory, (Item){.name = "Gizmo",.quantity = 25,.price = 9.99 });
    push(&inventory, (Item){.name = "Doodad",.quantity = 75,.price = 3.49 });

    printf("Current inventory:\n");
    while (!is_empty(&inventory)) {
        Item item = pop(&inventory);
        print_item(item);
    }

    return 0;
}