//Falcon-180B DATASET v1.0 Category: Cafe Billing System ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_CUSTOMERS 100
#define MAX_ORDERS 1000

typedef struct {
    int id;
    char name[50];
    char address[100];
    int phone;
} Customer;

typedef struct {
    int id;
    char name[50];
    double price;
} Item;

typedef struct {
    int id;
    int customer_id;
    int total_price;
} Order;

Customer customers[MAX_CUSTOMERS];
Item items[MAX_ITEMS];
Order orders[MAX_ORDERS];

int num_customers = 0;
int num_items = 0;
int num_orders = 0;

void add_customer(Customer* c) {
    strcpy(customers[num_customers].name, c->name);
    strcpy(customers[num_customers].address, c->address);
    customers[num_customers].phone = c->phone;
    customers[num_customers].id = num_customers + 1;
    num_customers++;
}

void add_item(Item* i) {
    strcpy(items[num_items].name, i->name);
    items[num_items].price = i->price;
    items[num_items].id = num_items + 1;
    num_items++;
}

void add_order(Order* o) {
    o->id = num_orders + 1;
    orders[num_orders] = *o;
    num_orders++;
}

void print_customers() {
    printf("Customer ID | Name | Address | Phone\n");
    for (int i = 0; i < num_customers; i++) {
        printf("%d | %s | %s | %d\n", customers[i].id, customers[i].name, customers[i].address, customers[i].phone);
    }
}

void print_items() {
    printf("Item ID | Name | Price\n");
    for (int i = 0; i < num_items; i++) {
        printf("%d | %s | %.2f\n", items[i].id, items[i].name, items[i].price);
    }
}

void print_orders() {
    printf("Order ID | Customer ID | Total Price\n");
    for (int i = 0; i < num_orders; i++) {
        printf("%d | %d | %.2f\n", orders[i].id, orders[i].customer_id, orders[i].total_price);
    }
}

int main() {
    Customer c1 = {1, "John Doe", "123 Main St.", 5551234};
    add_customer(&c1);

    Item i1 = {1, "Coffee", 2.50};
    add_item(&i1);

    Order o1 = {1, 1, 2.50};
    add_order(&o1);

    print_customers();
    print_items();
    print_orders();

    return 0;
}