//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: safe
#include <stdio.h>
#include <stdlib.h>

// Define a structure for a customer
typedef struct customer {
    char name[50];
    char address[100];
    int phone;
} customer;

// Define a structure for a menu item
typedef struct menu_item {
    char name[50];
    double price;
    int quantity;
} menu_item;

// Create a list of customers
customer customers[] = {
    {"John Doe", "123 Main St.", 5551234},
    {"Jane Doe", "456 Oak Ave.", 5552345},
    {"Bill Smith", "789 Park Ave.", 5553456}
};

// Create a list of menu items
menu_item menu_items[] = {
    {"Coffee", 2.50, 10},
    {"Tea", 3.00, 8},
    {"Juice", 3.50, 6},
    {"Smoothie", 4.00, 4}
};

// Calculate the total cost of an order
double calculate_total_cost(menu_item items[], int num_items) {
    double total_cost = 0.0;
    for (int i = 0; i < num_items; i++) {
        total_cost += items[i].price * items[i].quantity;
    }
    return total_cost;
}

// Print the bill
void print_bill(customer customer, menu_item items[], int num_items, double total_cost) {
    printf("Customer Name: %s\n", customer.name);
    printf("Address: %s\n", customer.address);
    printf("Phone Number: %d\n", customer.phone);

    printf("Items Ordered:\n");
    for (int i = 0; i < num_items; i++) {
        printf("%s - %d units @ $%.2lf = $%.2lf\n", items[i].name, items[i].quantity, items[i].price, items[i].price * items[i].quantity);
    }

    printf("Total Cost: $%.2lf\n", total_cost);
    printf("Thank you for your order, %s!\n", customer.name);
}

int main() {
    // Create an order
    menu_item items[] = {
        {"Coffee", 2.50, 2},
        {"Tea", 3.00, 1},
        {"Juice", 3.50, 3}
    };

    // Calculate the total cost of the order
    double total_cost = calculate_total_cost(items, 3);

    // Print the bill
    print_bill(customers[0], items, 3, total_cost);

    return 0;
}