//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>

#define I2C_SLAVE_FORCE 0x0706
#define TEMP_REG 0x00
#define TEMP_RESOLUTION 12

int main() {
    int file;
    int addr = 0x28;
    char filename[10] = "/dev/i2c-1";
    ssize_t count;
    char buf[10];
    int temperature;

    // Open the file
    if ((file = open(filename, O_RDWR)) < 0) {
        printf("Failed to open the bus.\n");
        exit(1);
    }

    // Set the slave address
    if (ioctl(file, I2C_SLAVE_FORCE, addr) < 0) {
        printf("Failed to acquire bus access and/or talk to slave.\n");
        exit(1);
    }

    // Read the temperature
    count = read(file, buf, 2);
    if (count!= 2) {
        printf("Failed to read from the device.\n");
        exit(1);
    }

    // Convert the temperature
    temperature = buf[0] << 8 | buf[1];
    temperature = (temperature & 0xFC00) >> 6;
    temperature = temperature * 100;

    // Print the temperature
    printf("Temperature: %d.%02d C\n", temperature / 100, abs(temperature % 100));

    // Close the file
    close(file);

    return 0;
}