//Code Llama-13B DATASET v1.0 Category: Cafe Billing System ; Style: shocked
// C Cafe Billing System

#include <stdio.h>

// Define the menu items
typedef struct {
    char name[20];
    float price;
} MenuItem;

MenuItem menu[] = {
    {"Coffee", 3.00},
    {"Tea", 2.50},
    {"Cappuccino", 4.00},
    {"Latte", 4.50},
    {"Mocha", 5.00},
    {"Scone", 2.00},
    {"Danish", 3.00},
    {"Bagel", 2.50},
    {"Toast", 2.00},
};

// Define the number of menu items
#define NUM_MENU_ITEMS (sizeof(menu) / sizeof(menu[0]))

// Define the number of customers
#define NUM_CUSTOMERS 5

// Define the total number of menu items
#define TOTAL_MENU_ITEMS (NUM_MENU_ITEMS * NUM_CUSTOMERS)

// Define the total amount of money
#define TOTAL_MONEY 200.00

// Define the tax rate
#define TAX_RATE 0.08

// Define the function to calculate the total cost
float calculateTotalCost(float price, int quantity) {
    return price * quantity;
}

// Define the function to calculate the total tax
float calculateTotalTax(float price, int quantity) {
    return TAX_RATE * calculateTotalCost(price, quantity);
}

// Define the function to calculate the total bill
float calculateTotalBill(float price, int quantity) {
    return calculateTotalCost(price, quantity) + calculateTotalTax(price, quantity);
}

// Define the function to display the menu
void displayMenu() {
    printf("Welcome to our cafe!\n");
    printf("Menu:\n");
    for (int i = 0; i < NUM_MENU_ITEMS; i++) {
        printf("%d. %s - $%.2f\n", i + 1, menu[i].name, menu[i].price);
    }
}

// Define the function to display the bill
void displayBill(float totalCost, float totalTax, float totalBill) {
    printf("Total Cost: $%.2f\n", totalCost);
    printf("Total Tax: $%.2f\n", totalTax);
    printf("Total Bill: $%.2f\n", totalBill);
}

// Define the function to display the customer's order
void displayOrder(int order) {
    printf("Order %d: %s\n", order + 1, menu[order].name);
}

// Define the function to display the customer's bill
void displayCustomerBill(float totalCost, float totalTax, float totalBill) {
    printf("Total Cost: $%.2f\n", totalCost);
    printf("Total Tax: $%.2f\n", totalTax);
    printf("Total Bill: $%.2f\n", totalBill);
}

// Define the function to calculate the customer's order
void calculateOrder(int order) {
    int quantity = 0;
    float totalCost = 0.00;
    float totalTax = 0.00;
    float totalBill = 0.00;

    // Calculate the total cost
    totalCost = calculateTotalCost(menu[order].price, quantity);

    // Calculate the total tax
    totalTax = calculateTotalTax(menu[order].price, quantity);

    // Calculate the total bill
    totalBill = calculateTotalBill(menu[order].price, quantity);

    // Display the customer's order
    displayOrder(order);

    // Display the customer's bill
    displayCustomerBill(totalCost, totalTax, totalBill);
}

// Define the function to calculate the cafe's total bill
void calculateCafeBill() {
    float totalCost = 0.00;
    float totalTax = 0.00;
    float totalBill = 0.00;

    // Calculate the total cost
    for (int i = 0; i < NUM_MENU_ITEMS; i++) {
        totalCost += calculateTotalCost(menu[i].price, NUM_CUSTOMERS);
    }

    // Calculate the total tax
    totalTax = calculateTotalTax(totalCost, NUM_CUSTOMERS);

    // Calculate the total bill
    totalBill = calculateTotalBill(totalCost, NUM_CUSTOMERS);

    // Display the cafe's bill
    displayBill(totalCost, totalTax, totalBill);
}

int main() {
    // Display the menu
    displayMenu();

    // Calculate the cafe's total bill
    calculateCafeBill();

    // Calculate the customer's order
    calculateOrder(1);

    // Calculate the customer's order
    calculateOrder(2);

    // Calculate the customer's order
    calculateOrder(3);

    // Calculate the customer's order
    calculateOrder(4);

    // Calculate the customer's order
    calculateOrder(5);

    return 0;
}