//GPT-4o-mini DATASET v1.0 Category: Warehouse Management System ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct {
    int id;
    char name[50];
    int quantity;
    float price;
} Item;

typedef struct {
    Item items[MAX_ITEMS];
    int count;
} Warehouse;

void addItem(Warehouse *warehouse, int id, const char *name, int quantity, float price) {
    if (warehouse->count < MAX_ITEMS) {
        warehouse->items[warehouse->count].id = id;
        strcpy(warehouse->items[warehouse->count].name, name);
        warehouse->items[warehouse->count].quantity = quantity;
        warehouse->items[warehouse->count].price = price;
        warehouse->count++;
        printf("Oh, my dear! You've added %s to the warehouse.\n", name);
    } else {
        printf("Alas! The warehouse is full of cherished items.\n");
    }
}

void displayItems(const Warehouse *warehouse) {
    if (warehouse->count == 0) {
        printf("The warehouse is empty, waiting for the love of a new item.\n");
        return;
    }
    printf("In this warehouse, the following treasures are kept:\n");
    for (int i = 0; i < warehouse->count; i++) {
        printf("ID: %d, Name: %s, Quantity: %d, Price: $%.2f\n", 
               warehouse->items[i].id, 
               warehouse->items[i].name, 
               warehouse->items[i].quantity, 
               warehouse->items[i].price);
    }
}

void removeItem(Warehouse *warehouse, int id) {
    for (int i = 0; i < warehouse->count; i++) {
        if (warehouse->items[i].id == id) {
            printf("Farewell, dear %s! You are being removed from the warehouse.\n", warehouse->items[i].name);
            for (int j = i; j < warehouse->count - 1; j++) {
                warehouse->items[j] = warehouse->items[j + 1];
            }
            warehouse->count--;
            return;
        }
    }
    printf("Alas, no item with ID %d exists to tenderly part with.\n", id);
}

void findItem(const Warehouse *warehouse, int id) {
    for (int i = 0; i < warehouse->count; i++) {
        if (warehouse->items[i].id == id) {
            printf("Oh my heart! The beloved item is found:\n");
            printf("ID: %d, Name: %s, Quantity: %d, Price: $%.2f\n", 
                   warehouse->items[i].id, 
                   warehouse->items[i].name, 
                   warehouse->items[i].quantity, 
                   warehouse->items[i].price);
            return;
        }
    }
    printf("My darling! No such treasure can be found with ID %d.\n", id);
}

int main() {
    Warehouse warehouse = { .count = 0 };
    
    addItem(&warehouse, 1, "Rose", 50, 1.99);
    addItem(&warehouse, 2, "Chocolate", 30, 2.50);
    addItem(&warehouse, 3, "Teddy Bear", 20, 15.00);
    
    displayItems(&warehouse);
    
    findItem(&warehouse, 2);
    
    removeItem(&warehouse, 1);
    
    displayItems(&warehouse);
    
    addItem(&warehouse, 4, "Love Letter", 10, 0.05);
    displayItems(&warehouse);

    return 0;
}