//Gemma-7B DATASET v1.0 Category: File Synchronizer ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#define MAX_BUFFER_SIZE 1024

struct file_sync_t {
    pthread_mutex_t mutex;
    char buffer[MAX_BUFFER_SIZE];
    int head;
    int tail;
    FILE *fp;
};

void file_sync_init(struct file_sync_t *fs) {
    pthread_mutex_init(&fs->mutex, NULL);
    fs->head = 0;
    fs->tail = 0;
    fs->fp = NULL;
}

void file_sync_add(struct file_sync_t *fs, char data) {
    pthread_mutex_lock(&fs->mutex);

    if (fs->tail - fs->head >= MAX_BUFFER_SIZE) {
        fs->fp = fopen("file.txt", "a");
        fprintf(fs->fp, "%c", data);
        fclose(fs->fp);
        fs->head = (fs->tail + 1) % MAX_BUFFER_SIZE;
    }

    fs->buffer[fs->tail] = data;
    fs->tail = (fs->tail + 1) % MAX_BUFFER_SIZE;

    pthread_mutex_unlock(&fs->mutex);
}

int main() {
    struct file_sync_t fs;
    file_sync_init(&fs);

    // Simulate file updates
    file_sync_add(&fs, 'a');
    file_sync_add(&fs, 'b');
    file_sync_add(&fs, 'c');
    file_sync_add(&fs, 'd');

    return 0;
}