//Falcon2-11B DATASET v1.0 Category: Matrix operations ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Function to print matrix
void printMatrix(int matrix[][3], int size) {
    int i, j;
    for (i = 0; i < size; i++) {
        for (j = 0; j < size; j++) {
            printf("%d ", matrix[i][j]);
        }
        printf("\n");
    }
}

// Function to add two matrices
void addMatrices(int matrix1[][3], int matrix2[][3], int size) {
    int i, j;
    for (i = 0; i < size; i++) {
        for (j = 0; j < size; j++) {
            matrix1[i][j] = matrix1[i][j] + matrix2[i][j];
        }
    }
}

// Function to subtract two matrices
void subtractMatrices(int matrix1[][3], int matrix2[][3], int size) {
    int i, j;
    for (i = 0; i < size; i++) {
        for (j = 0; j < size; j++) {
            matrix1[i][j] = matrix1[i][j] - matrix2[i][j];
        }
    }
}

// Function to multiply two matrices
void multiplyMatrices(int matrix1[][3], int matrix2[][3], int size) {
    int i, j, k;
    for (i = 0; i < size; i++) {
        for (j = 0; j < size; j++) {
            int sum = 0;
            for (k = 0; k < size; k++) {
                sum += matrix1[i][k] * matrix2[k][j];
            }
            matrix1[i][j] = sum;
        }
    }
}

// Function to transpose a matrix
void transposeMatrix(int matrix[][3], int size) {
    int i, j;
    for (i = 0; i < size; i++) {
        for (j = 0; j < size; j++) {
            int temp = matrix[j][i];
            matrix[j][i] = matrix[i][j];
            matrix[i][j] = temp;
        }
    }
}

// Main function
int main() {
    int matrix1[][3] = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
    int matrix2[][3] = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
    int size = 3;
    int matrix3[3][3];

    // Print matrix 1
    printf("Matrix 1:\n");
    printMatrix(matrix1, size);

    // Add matrices
    printf("Matrix 1 + Matrix 2:\n");
    addMatrices(matrix1, matrix2, size);
    printMatrix(matrix1, size);

    // Subtract matrices
    printf("Matrix 1 - Matrix 2:\n");
    subtractMatrices(matrix1, matrix2, size);
    printMatrix(matrix1, size);

    // Multiply matrices
    printf("Matrix 1 x Matrix 2:\n");
    multiplyMatrices(matrix1, matrix2, size);
    printMatrix(matrix1, size);

    // Transpose matrix
    printf("Transpose of Matrix 1:\n");
    transposeMatrix(matrix1, size);
    printMatrix(matrix1, size);

    return 0;
}