//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: Cryptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSES 5
#define MAX_QUEUE_SIZE 10

typedef struct Process {
  int process_id;
  char name[20];
  int burst_time;
  int waiting_time;
  int turn_around_time;
} Process;

Process processes[MAX_PROCESSES];

void initialize_processes() {
  for (int i = 0; i < MAX_PROCESSES; i++) {
    processes[i].process_id = i + 1;
    processes[i].name[0] = 'A' + i;
    processes[i].burst_time = rand() % 5 + 1;
    processes[i].waiting_time = 0;
    processes[i].turn_around_time = 0;
  }
}

void simulate_cpu_scheduling() {
  int current_process = 0;
  int quantum = 0;
  int time_quantum = 3;

  while (!processes[current_process].waiting_time) {
    quantum++;

    if (quantum % time_quantum == 0) {
      processes[current_process].waiting_time--;
      printf("Process %d is ready.\n", processes[current_process].process_id);
    }

    if (processes[current_process].burst_time) {
      processes[current_process].burst_time--;
    }

    if (processes[current_process].burst_time == 0) {
      processes[current_process].turn_around_time = quantum;
      current_process = (current_process + 1) % MAX_PROCESSES;
    }
  }

  printf("CPU Scheduling Simulation Complete.\n");
}

int main() {
  initialize_processes();
  simulate_cpu_scheduling();

  return 0;
}