//GEMINI-pro DATASET v1.0 Category: Graph Coloring Problem ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>

// Define the number of colors and vertices
#define NUM_COLORS 3
#define NUM_VERTICES 4

// Define the adjacency matrix
int adj_matrix[NUM_VERTICES][NUM_VERTICES] = {
    {0, 1, 0, 0},
    {1, 0, 1, 0},
    {0, 1, 0, 1},
    {0, 0, 1, 0}
};

// Define the color array
int color_array[NUM_VERTICES];

// Function to check if a vertex is safe to color with a given color
int is_safe(int vertex, int color) {
    for (int i = 0; i < NUM_VERTICES; i++) {
        if (adj_matrix[vertex][i] == 1 && color_array[i] == color) {
            return 0;
        }
    }
    return 1;
}

// Function to find a valid coloring of the graph
int graph_coloring(int vertex) {
    // Base case: If all vertices have been colored, return true
    if (vertex == NUM_VERTICES) {
        return 1;
    }

    // Recursive case: Try all possible colors for the current vertex
    for (int color = 1; color <= NUM_COLORS; color++) {
        // If the current color is safe for the current vertex, assign it
        if (is_safe(vertex, color)) {
            color_array[vertex] = color;

            // Recursively check if the rest of the graph can be colored
            if (graph_coloring(vertex + 1)) {
                return 1;
            }

            // If the rest of the graph cannot be colored, remove the current color
            color_array[vertex] = 0;
        }
    }

    // If no valid coloring was found, return false
    return 0;
}

// Main function
int main() {
    // Initialize the color array to zero
    for (int i = 0; i < NUM_VERTICES; i++) {
        color_array[i] = 0;
    }

    // Check if the graph can be colored
    if (graph_coloring(0)) {
        // If the graph can be colored, print the color array
        printf("Valid coloring found:\n");
        for (int i = 0; i < NUM_VERTICES; i++) {
            printf("Vertex %d: Color %d\n", i, color_array[i]);
        }
    } else {
        // If the graph cannot be colored, print an error message
        printf("No valid coloring found.\n");
    }

    return 0;
}