//Code Llama-13B DATASET v1.0 Category: Cafe Billing System ; Style: beginner-friendly
/*
 * C Cafe Billing System
 */

#include <stdio.h>
#include <stdlib.h>

// Structure to represent a customer
typedef struct {
    int id;
    char name[50];
    float total;
} Customer;

// Structure to represent a menu item
typedef struct {
    int id;
    char name[50];
    float price;
} MenuItem;

// Function to print the bill for a customer
void printBill(Customer customer) {
    printf("Customer ID: %d\n", customer.id);
    printf("Name: %s\n", customer.name);
    printf("Total: $%.2f\n", customer.total);
}

// Function to calculate the total cost of a customer's order
float calculateTotal(Customer customer, MenuItem menuItems[], int numItems) {
    float total = 0.0;
    for (int i = 0; i < numItems; i++) {
        total += menuItems[i].price;
    }
    return total;
}

// Function to create a new customer
Customer createCustomer(int id, char name[50]) {
    Customer customer;
    customer.id = id;
    strcpy(customer.name, name);
    return customer;
}

// Function to create a new menu item
MenuItem createMenuItem(int id, char name[50], float price) {
    MenuItem menuItem;
    menuItem.id = id;
    strcpy(menuItem.name, name);
    menuItem.price = price;
    return menuItem;
}

// Function to add a menu item to a customer's order
void addMenuItem(Customer customer, MenuItem menuItem) {
    customer.total += menuItem.price;
}

int main() {
    // Create a menu item
    MenuItem coffee = createMenuItem(1, "Coffee", 3.50);
    MenuItem cake = createMenuItem(2, "Cake", 5.00);
    MenuItem cookie = createMenuItem(3, "Cookie", 2.50);

    // Create a customer
    Customer customer1 = createCustomer(1, "John Doe");

    // Add menu items to the customer's order
    addMenuItem(customer1, coffee);
    addMenuItem(customer1, cake);

    // Print the bill for the customer
    printBill(customer1);

    return 0;
}