//MISTRAL-7B DATASET v1.0 Category: Searching algorithm ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#define SIZE 10

typedef struct {
    int key;
    int index;
} Element;

void init_array(Element arr[]) {
    for (int i = 0; i < SIZE; i++) {
        arr[i].key = i * 2 + 1;
        arr[i].index = i;
    }
}

int search(Element arr[], int size, int target) {
    int left = 0;
    int right = size - 1;

    while (left <= right) {
        int mid = left + (right - left) / 2;

        if (arr[mid].key == target) {
            return arr[mid].index;
        }

        if (arr[mid].key < target) {
            left = mid + 1;
        } else {
            right = mid - 1;
        }
    }

    return -1;
}

void print_array(Element arr[], int size) {
    for (int i = 0; i < size; i++) {
        printf("Element %d: key = %d, index = %d\n", i, arr[i].key, arr[i].index);
    }
}

int main() {
    Element arr[SIZE];

    init_array(arr);

    print_array(arr, SIZE);

    int target = 9;
    int index = search(arr, SIZE, target);

    if (index != -1) {
        printf("Element %d found at index %d\n", target, index);
    } else {
        printf("Element %d not found\n", target);
    }

    return 0;
}