//MISTRAL-7B DATASET v1.0 Category: Levenshtein Distance Calculator ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STRING_LENGTH 100

typedef struct {
    char str[MAX_STRING_LENGTH];
    int len;
} String;

void fatal(const char *msg) {
    printf("%s\n", msg);
    abort();
}

void init_string(String *s, const char *str) {
    strcpy(s->str, str);
    s->len = strlen(s->str);
}

void destroy_string(String *s) {
    memset(s, 0, sizeof(String));
}

int levenshtein_distance(const String *s1, const String *s2) {
    int d[s1->len + 1][s2->len + 1];

    for (int i = 0; i <= s1->len; i++) {
        for (int j = 0; j <= s2->len; j++) {
            if (i == 0)
                d[i][j] = j;
            else if (j == 0)
                d[i][j] = i;
            else if (s1->str[i - 1] == s2->str[j - 1])
                d[i][j] = d[i - 1][j - 1];
            else
                d[i][j] = 1 + min(min(d[i - 1][j], d[i][j - 1]), d[i - 1][j - 1]);
        }
    }

    return d[s1->len][s2->len];
}

int min(int a, int b) {
    return (a < b) ? a : b;
}

int main() {
    String s1, s2;

    init_string(&s1, "kitten");
    init_string(&s2, "sitting");

    int dist = levenshtein_distance(&s1, &s2);

    printf("Levenshtein Distance: %d\n", dist);

    destroy_string(&s1);
    destroy_string(&s2);

    return EXIT_SUCCESS;
}