//GEMINI-pro DATASET v1.0 Category: File handling ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// The mighty warrior who will slay the file.
typedef struct {
  FILE *file;
  char *filename;
} FileSlasher;

// Let's create a new warrior!
FileSlasher *new_file_slasher(const char *filename) {
  FileSlasher *slasher = malloc(sizeof(FileSlasher));
  if (slasher == NULL) {
    fprintf(stderr, "Oh no! I couldn't create the warrior!\n");
    return NULL;
  }

  slasher->filename = strdup(filename);
  if (slasher->filename == NULL) {
    fprintf(stderr, "Oops! I couldn't create the warrior's name!\n");
    free(slasher);
    return NULL;
  }

  slasher->file = fopen(filename, "w");
  if (slasher->file == NULL) {
    fprintf(stderr, "Darn! I couldn't open the file!\n");
    free(slasher->filename);
    free(slasher);
    return NULL;
  }

  return slasher;
}

// And now, let's give our warrior a mighty sword!
void file_slasher_write(FileSlasher *slasher, const char *text) {
  if (slasher == NULL || slasher->file == NULL) {
    fprintf(stderr, "Oh dear, seems like your warrior is missing a sword!\n");
    return;
  }

  fprintf(slasher->file, "%s", text);
}

// But alas, all battles must end.
void file_slasher_close(FileSlasher *slasher) {
  if (slasher == NULL) {
    return;
  }

  if (slasher->file != NULL) {
    fclose(slasher->file);
    slasher->file = NULL;
  }

  if (slasher->filename != NULL) {
    free(slasher->filename);
    slasher->filename = NULL;
  }

  free(slasher);
}

int main() {
  // Let's create a glorious file!
  FileSlasher *slasher = new_file_slasher("glorious_file.txt");
  if (slasher == NULL) {
    return EXIT_FAILURE;
  }

  // Now, let's fill it with tales of bravery!
  file_slasher_write(slasher, "Once upon a time, there was a mighty warrior who slayed a thousand files.\n");
  file_slasher_write(slasher, "With each stroke of his sword, he carved his name into the annals of legend.\n");
  file_slasher_write(slasher, "And so, the warrior's tale was told for generations to come.\n");

  // But all good things must come to an end.
  file_slasher_close(slasher);

  return EXIT_SUCCESS;
}